# Create a new Laravel project
composer create-project laravel/laravel VapeBay
cd VapeBay

# Install Laravel Breeze with Bootstrap
composer require laravel/breeze --dev
php artisan breeze:install blade --dark
npm install bootstrap @popperjs/core

# Initialize Git repository
git init
git add .
git commit -m "Initial commit: Fresh Laravel project with Breeze"

# Create a HomeController
php artisan make:controller HomeController

# Configure database in .env
# Replace MySQL configuration settings
sed -i '' 's/DB_DATABASE=laravel/DB_DATABASE=vapebay/g' .env
sed -i '' 's/DB_USERNAME=root/DB_USERNAME=your_mysql_username/g' .env
sed -i '' 's/DB_PASSWORD=/DB_PASSWORD=your_mysql_password/g' .env

# Install npm packages and build assets
npm install
npm run build

# Run the migrations to test database connection
php artisan migrate

# Start the development server
php artisan serve